unit TrafficM;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Tbag, StdCtrls, ComCtrls, ExtCtrls, Buttons;

type
  TfrmTrafficMain = class(TForm)
    Bag1: TBag32;
    Panel2: TPanel;
    L1: TShape;
    L2: TShape;
    L3: TShape;
    Panel3: TPanel;
    L4: TShape;
    L5: TShape;
    L6: TShape;
    SpeedButton1: TSpeedButton;
    btnDisplay: TButton;
    Timer1: TTimer;
    btnStart: TButton;
    pnlTraffic: TPanel;
    lbTraffic: TListBox;
    edTraffic: TEdit;
    btnEdit: TButton;
    btnAdd: TButton;
    btnDel: TButton;
    procedure FormShow(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
    procedure SpeedButton1Click(Sender: TObject);
    procedure lbTrafficClick(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure btnDisplayClick(Sender: TObject);
    procedure btnStartClick(Sender: TObject);
    procedure btnAddClick(Sender: TObject);
    procedure btnDelClick(Sender: TObject);
    procedure btnEditClick(Sender: TObject);
  private
    Nodes: array[0..20] of TTreeNode;
    KeyList: TStringList;
  public
    { Public declarations }
  end;

var
  frmTrafficMain: TfrmTrafficMain;

implementation

{$R *.DFM}

uses About3K;

procedure TfrmTrafficMain.FormShow(Sender: TObject);
begin
  with Bag1 do begin
    GetFormPlace('FORMPLACE',Self);
    GetStrings('TRAFFIC_LIST',lbTraffic.Items);
    lbTraffic.ItemIndex := GetInteger('LIST_INDEX',-1);
    lbTrafficClick(lbTraffic);
    btnDisplay.Tag := GetInteger('BTN_DISPLAY',0);
    btnDisplayClick(nil);
    Timer1.Enabled := GetBoolean('TIMER',False);
    btnStartClick(nil);
  end;
end;

procedure TfrmTrafficMain.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
  with Bag1 do begin
    SetFormPlace('FORMPLACE',Self);
    SetStrings('TRAFFIC_LIST',lbTraffic.Items);
    SetInteger('LIST_INDEX',lbTraffic.ItemIndex);
    SetInteger('BTN_DISPLAY',btnDisplay.Tag);
    SetBoolean('TIMER',Timer1.Enabled);
  end;
end;

procedure TfrmTrafficMain.SpeedButton1Click(Sender: TObject);
begin
  with TfrmAbout3K.Construct('About Traffic (TBag32 demo)') do try
    ShowModal;
  finally
    Free;
  end;
end;

procedure TfrmTrafficMain.lbTrafficClick(Sender: TObject);
var
  s: string;
  p,ix,ix2: integer;
  c: longint;
begin
  if lbTraffic.ItemIndex < 0 then exit;
  with lbTraffic do s := Items[ItemIndex];
  edTraffic.Text := s;
  p := Pos(' ',s);
  if p > 1 then Timer1.Interval := StrToInt(Copy(s,1,p-1));
  for ix := 1 to 6 do begin
    p := Pos('cl',s);
    if p = 0 then Break;
    s := Copy(s,p,255);
    p := Length(s)+1;
    for ix2 := 1 to Length(s) do begin
      if s[ix2] in [',',' '] then begin
        p := ix2;
        Break;
      end;
    end;
    if IdentToColor(Copy(s,1,p-1),c) then
      with FindComponent('L'+IntToStr(ix)) as TShape do
        Brush.Color := TColor(c);
    s := Copy(s,p+1,255);
  end;
end;

procedure TfrmTrafficMain.Timer1Timer(Sender: TObject);
begin
  with lbTraffic do
    ItemIndex := (ItemIndex + 1) mod Items.Count;
  lbTrafficClick(lbTraffic);
end;

procedure TfrmTrafficMain.btnDisplayClick(Sender: TObject);
const
  caps: array[0..1] of string = ('Show','Hide');
begin
  with btnDisplay do begin
    if Sender <> nil then Tag := (Tag + 1) mod 2;
    pnlTraffic.Visible := (Tag = 1);
    Caption := caps[Tag]+' Traffic &List';
  end;
end;

procedure TfrmTrafficMain.btnStartClick(Sender: TObject);
const
  caps: array[boolean] of string = ('&Start','&Stop');
begin
  with btnStart do begin
    if Sender <> nil then with Timer1 do Enabled := not Enabled;
    Caption := caps[Timer1.Enabled];
  end;
  btnEdit.Enabled := not Timer1.Enabled;
  btnAdd.Enabled := not Timer1.Enabled;
  btnDel.Enabled := not Timer1.Enabled;
  edTraffic.Visible := not Timer1.Enabled;
end;

procedure TfrmTrafficMain.btnAddClick(Sender: TObject);
begin
  with lbTraffic do begin
    if (ItemIndex >=0) and (ItemIndex < Items.Count-1)
      then Items.Insert(ItemIndex+1,edTraffic.Text)
      else Items.Add(edTraffic.Text);
    ItemIndex := Items.IndexOf(edTraffic.Text);
    lbTrafficClick(lbTraffic);
  end;
end;

procedure TfrmTrafficMain.btnDelClick(Sender: TObject);
var
  ix: integer;
begin
  with lbTraffic do begin
   ix := ItemIndex;
   if ix >=0 then Items.Delete(ix);
   if ix >= Items.Count then dec(ix);
   ItemIndex := ix;
   lbTrafficClick(lbTraffic);
  end;
end;

procedure TfrmTrafficMain.btnEditClick(Sender: TObject);
var
  ix: integer;
begin
  with lbTraffic do begin
    ix := ItemIndex;
    if ItemIndex >=0 then Items[ItemIndex] := edTraffic.Text;
    ItemIndex := ix;
    lbTrafficClick(lbTraffic);
  end;
end;

end.
